//Displays and hides the prefChoice div, which contains the Viewing Options.
//You can reverse the defaults here. But change the explanations in Viewing Options.
var defaults = new Object();
defaults["highContrast"] = "off";
defaults["largeFont"] = "off";
defaults["hoverHelper"] = "on";
defaults["yellowHighlight"] = "on";
defaults["brownTextcolor"] = "on";
defaults["scholarsView"] = "off";

jQuery(document).ready(function() {
	jQuery("#Preferences").click(
		function() {
		    jQuery ("#prefChoice").toggle();
	    }
	  
    ); // end click
	//This happens once when the document is ready
	    jQuery ("#prefChoice").hide();

	// iterate through all prefs in the section and initialize them
	// if cookie is set, use cookie value.  otherwise, use a default.
	$("#prefChoice input[type='checkbox']").each(function(pref) {
		var prefName = jQuery(this).attr("id");
		var cookieValue = jQuery.cookie(prefName);
		if (cookieValue === undefined) {
			//no cookie, so set default
			if (defaults[prefName] == "on") {
				jQuery("#"+prefName).click();
			}
		} else if (cookieValue === "on") {
			if (prefName === "smartPhoneView") {
				jQuery("#"+prefName).prop("checked", "checked");
				toggleQSClasses(this, '.smartPhoneView', 'on');
			} else {
				jQuery("#"+prefName).click();
			}
		} else {
			// pref is set by cookie to be off, do nothing
		}
	});

}); // end ready

//preChoice 
